<?php
require __DIR__ . '/common.php';

$body = read_json_body();
$session_id = (string)($body['session_id'] ?? '');
$answers_in = $body['answers'] ?? [];

if ($session_id === '' || !is_array($answers_in)) {
  json_out(['ok'=>false,'message'=>'session_id y answers requeridos'], 400);
}

$S = load_session($session_id);
if (!$S) {
  json_out(['ok'=>false,'message'=>'sesion no encontrada'], 404);
}

if (!isset($S['answers']) || !is_array($S['answers'])) $S['answers'] = [];

foreach ($answers_in as $k => $v) {
  $key = (string)$k;
  $val = is_array($v) ? ($v['value'] ?? '') : $v;
  $conf = is_array($v) ? ($v['confidence'] ?? 1.0) : 1.0;

  $S['answers'][$key] = [
    'value' => $val,
    'confidence' => (float)$conf,
    'ts' => now_ms()
  ];
}

append_event($session_id, 'ANSWER_UPSERT', 'ui', ['answers'=>$answers_in]);

$questions = load_cfg('questions.json');
$branches  = load_cfg('branches.json');
$policy    = load_cfg('policy_pack.json');

$S['metrics']['completion_pct'] = derive_completion($S['answers'], $questions);
$S['zero_shot'] = derive_zero_shot($S, $branches, $policy);
$S['state'] = 'UPDATED';

save_session($S);

json_out(['ok'=>true,'session'=>$S]);
