<?php
declare(strict_types=1);
require __DIR__ . '/common.php';

$path = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
$path = preg_replace('#^/+#','/',$path ?? '/');

$map = [
  '/api/session/new' => 'session_new.php',
  '/api/questions'   => 'questions.php',
  '/api/answers/upsert' => 'answers_upsert.php',
  '/api/ingest/audio'   => 'ingest_audio.php',
  '/api/sessions'    => 'sessions.php'
];

if (!isset($map[$path])) {
  json_out(['ok'=>false,'message'=>'ruta no encontrada','path'=>$path], 404);
}

require __DIR__ . '/' . $map[$path];
