<?php
require __DIR__ . '/common.php';

$session_id = (string)($_POST['session_id'] ?? '');
if ($session_id === '') {
  json_out(['ok'=>false,'message'=>'session_id requerido'], 400);
}
$S = load_session($session_id);
if (!$S) json_out(['ok'=>false,'message'=>'sesion no encontrada'], 404);

if (!isset($_FILES['audio'])) {
  json_out(['ok'=>false,'message'=>'archivo audio requerido'], 400);
}

$f = $_FILES['audio'];
if (($f['error'] ?? UPLOAD_ERR_OK) !== UPLOAD_ERR_OK) {
  json_out(['ok'=>false,'message'=>'error al subir audio','code'=>$f['error']], 400);
}

$ext = pathinfo((string)$f['name'], PATHINFO_EXTENSION);
$ext = preg_replace('/[^a-zA-Z0-9]/','', $ext);
if ($ext === '') $ext = 'webm';

$fname = safe_id($session_id) . '_' . now_ms() . '.' . $ext;
$dst = uploads_dir() . '/' . $fname;

if (!move_uploaded_file($f['tmp_name'], $dst)) {
  json_out(['ok'=>false,'message'=>'no se pudo guardar audio'], 500);
}

$S['buffer']['audio_refs'] = $S['buffer']['audio_refs'] ?? [];
$S['buffer']['audio_refs'][] = $fname;
$S['state'] = 'AUDIO_RECEIVED';

append_event($session_id, 'AUDIO_REF', 'ui', ['file'=>$fname]);
save_session($S);

json_out(['ok'=>true,'session_id'=>$session_id,'file'=>$fname]);
