<?php
require __DIR__ . '/common.php';

$body = read_json_body();
$branch_id = (string)($body['branch_id'] ?? ($_GET['branch_id'] ?? ''));

$session_id = new_session_id();
$S = [
  'session_id' => $session_id,
  'branch_id'  => $branch_id,
  'origin'     => (string)($body['origin'] ?? ($_GET['origin'] ?? 'kiosk')),
  'state'      => 'NEW',
  'answers'    => [],
  'metrics'    => [],
  'zero_shot'  => ['score'=>0.0,'segment'=>'BAJO_POTENCIAL','components'=>[],'version'=>'zs_2026_01']
];

append_event($session_id, 'SESSION_NEW', 'api', ['branch_id'=>$branch_id,'origin'=>$S['origin']]);
save_session($S);

json_out(['ok'=>true,'session'=>$S]);
