<?php
require __DIR__ . '/common.php';

$mode = (string)($_GET['mode'] ?? 'list');
if ($mode === 'session') {
  $id = (string)($_GET['id'] ?? '');
  if ($id === '') json_out(['ok'=>false,'message'=>'id requerido'], 400);
  $S = load_session($id);
  if (!$S) json_out(['ok'=>false,'message'=>'sesion no encontrada'], 404);
  json_out(['ok'=>true,'session'=>$S]);
}

$dir = data_dir();
$items = [];
foreach (glob($dir . '/session_*.json') as $p) {
  $S = load_json_file($p);
  if (!$S) continue;
  $items[] = [
    'session_id' => $S['session_id'] ?? '',
    'branch_id' => $S['branch_id'] ?? '',
    'origin' => $S['origin'] ?? '',
    'state' => $S['state'] ?? '',
    'last_update' => $S['last_update'] ?? 0,
    'completion_pct' => $S['metrics']['completion_pct'] ?? 0,
    'zero_shot_score' => $S['zero_shot']['score'] ?? 0,
    'zero_shot_segment' => $S['zero_shot']['segment'] ?? ''
  ];
}
usort($items, fn($a,$b) => (int)($b['last_update'] ?? 0) <=> (int)($a['last_update'] ?? 0));
json_out(['ok'=>true,'items'=>$items,'count'=>count($items)]);
